﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.DAL;
using AZVIC.Ei8htPOS.Entities;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class WebSettingsBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static WebSettings GetItem(Guid settingsID)
        {
            return WebSettingsDB.GetItem(settingsID);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<WebSettings> GetList(Guid settingsID)
        {
            return WebSettingsDB.GetList(settingsID);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid settingsID)
        {
            return WebSettingsDB.GetDataTable(settingsID);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid settingsID)
        {
            return WebSettingsDB.GetDataSet(settingsID);
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(WebSettings mySettings)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                WebSettingsDB.Save(mySettings);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
